// Copyright (C) 2017 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QT3DANIMATION_QCLOCK_H
#define QT3DANIMATION_QCLOCK_H

#include <Qt3DAnimation/qt3danimation_global.h>
#include <Qt3DCore/qnode.h>

QT_BEGIN_NAMESPACE

namespace Qt3DAnimation {

class QClockPrivate;

class Q_3DANIMATIONSHARED_EXPORT QClock : public Qt3DCore::QNode
{
    Q_OBJECT
    Q_PROPERTY(double playbackRate READ playbackRate WRITE setPlaybackRate NOTIFY playbackRateChanged)

public:
    explicit QClock(Qt3DCore::QNode *parent = nullptr);
    ~QClock();

    double playbackRate() const;
    void setPlaybackRate(double playbackRate);

Q_SIGNALS:
    void playbackRateChanged(double playbackRate);

protected:
    QClock(QClockPrivate &dd, Qt3DCore::QNode *parent = nullptr);

private:
    Q_DECLARE_PRIVATE(QClock)
};

} // namespace Qt3DAnimation

QT_END_NAMESPACE

#endif // QT3DANIMATION_QCLOCK_H
